// بيانات دخول مؤقتة
const ADMIN_EMAIL = "admin@eagle.com";
const ADMIN_PASS = "Eagle@E12@A$e";

// مصفوفة القطاعات الافتراضية
let finalPrizes = [
    { name: "حظ أوفر", weight: 80 },
    { name: "5000", weight: 5 },
    { name: "10000", weight: 10 },
    { name: "25000", weight: 5 },
];

// تسجيل الدخول
// تسجيل الدخول
async function login() {
    const email = document.getElementById("adminEmail").value;
    const pass = document.getElementById("adminPass").value;

    if (email === ADMIN_EMAIL && pass === ADMIN_PASS) {
        document.getElementById("loginForm").style.display = "none";
        document.getElementById("adminPanel").style.display = "block";

        // تحميل البيانات من السيرفر
        try {
            const res = await fetch('load_prizes.php'); // ← هنا القراءة من السيرفر
            if (res.ok) {
                finalPrizes = await res.json(); // تحديث مصفوفة finalPrizes بالقيم من JSON
            } else {
                alert("فشل تحميل البيانات، سيتم استخدام البيانات الافتراضية");
            }
        } catch (err) {
            console.error(err);
            alert("خطأ في الاتصال بالسيرفر، سيتم استخدام البيانات الافتراضية");
        }

        refreshAdminPanel(); // تحديث الجدول بعد تحميل البيانات
    } else {
        alert("خطأ في البريد الإلكتروني أو كلمة المرور!");
    }
}



// تحديث الجدول
function refreshAdminPanel() {
    const tbody = document.querySelector("#segmentsTable tbody");
    tbody.innerHTML = "";
    finalPrizes.forEach((p, index) => {
        const tr = document.createElement("tr");
        tr.innerHTML = `
            <td><input type="text" value="${p.name}" data-index="${index}" class="segmentName"></td>
            <td><input type="number" value="${p.weight}" min="0" max="100" data-index="${index}" class="segmentWeight"></td>
            <td><button onclick="deleteSegment(${index})">حذف</button></td>
        `;
        tbody.appendChild(tr);
    });
}

// إضافة قطاع جديد
document.getElementById("addSegmentBtn").onclick = function() {
    finalPrizes.push({ name: "جائزة جديدة", weight: 10 });
    refreshAdminPanel();
};

// حذف قطاع
function deleteSegment(index) {
    finalPrizes.splice(index, 1);
    refreshAdminPanel();
}
document.getElementById("saveSegmentsBtn").onclick = async function() {
    const names = document.querySelectorAll(".segmentName");
    const weights = document.querySelectorAll(".segmentWeight");

    names.forEach((input, i) => finalPrizes[i].name = input.value);
    weights.forEach((input, i) => finalPrizes[i].weight = parseInt(input.value) || 0);

    try {
        const response = await fetch('save_prizes.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(finalPrizes)
        });

        if (response.ok) {
            alert("تم حفظ التغييرات بنجاح!");
        } else {
            alert("حدث خطأ أثناء الحفظ على السيرفر!");
        }
    } catch (err) {
        console.error(err);
        alert("فشل الاتصال بالسيرفر!");
    }
};
